uniform vec3		sundir;
uniform vec3		moondir;
uniform vec3 		moonColor;
uniform float		moonCoronasMul;
		
uniform vec3 		earth_center;
uniform float 		length_unit;

varying vec3		viewdir;
uniform float 		sunpower;
uniform float 		inScatter;
varying float 		h;
uniform vec3		horizonColor;
uniform vec3		zenithColor;

//varying vec2		texcoords;
//uniform sampler2D	cloudsTex;
////////////////////////////

vec3 GetSolarRadiance();
vec3 GetSkyRadiance(vec3 camera, vec3 view_ray, float shadow_length,
    vec3 sun_direction, out vec3 transmittance);
vec3 GetSkyRadianceToPoint(vec3 camera, vec3 point, float shadow_length,
    vec3 sun_direction, out vec3 transmittance);
vec3 GetSunAndSkyIrradiance(
    vec3 p, vec3 normal, vec3 sun_direction, out vec3 sky_irradiance);
vec3 GetTrasmittanceTexture(vec2 uv);
vec3 GetScatteringTexture(vec3 uv);
float GetPhaseFunctions(vec3 view_ray, vec3 sun_direction, out float mie);

void main()
{
	vec3  	skyColor;
	vec3 	fFex;
	vec3 	fLin;
	vec3 	night=vec3(0.0,0.0,0.0);

	// DAY ///////////////////////////////////
	skyColor=vec3(max(dot(sundir,viewdir)-0.9999,0.0))*GetSolarRadiance()*sunpower;
	fLin=GetSkyRadiance(-earth_center.xyz, viewdir, 0.0, sundir, fFex)*inScatter;
	
	// NIGHT ///////////////////////////////////////////////////////////////////////////
	float nightMie=0.0;
	float nightRay=0.0;
	float gradientEXP=exp(-h*0.05);
	night += gradientEXP*horizonColor;
	night += (1.0-gradientEXP)*zenithColor;
	night += vec3(pow(max(dot(moondir,viewdir),0.0),150.0))*moonColor*moonCoronasMul;
	nightRay=GetPhaseFunctions(viewdir, moondir, nightMie);
	night *= 10.0;
	fLin+=(1.0-fFex)*(nightRay+nightMie)*moonCoronasMul*10.0;
	
	//////////////////////////////////////////////////////////////////////////////////////
	
	gl_FragColor.xyz=fLin+fFex*skyColor.xyz + night;
	gl_FragColor.w=1.0;
}
